/*
* Copyright (c) 1994-1998 Sun Microsystems, Inc. All Rights Reserved.
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for NON-COMMERCIAL or COMMERCIAL purposes and without fee is
* hereby granted. Please refer to the file
* http://java.sun.com/nav/business/trademark_guidelines.html for further
* important copyright and trademark information and to
* http://java.sun.com/nav/business/index.html for further important licensing
* information for the Java (tm) Technology.
* 
* SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
* SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
* IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
* NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
* LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
* ITS DERIVATIVES.
* 
* THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
* CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE PERFORMANCE,
* SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT NAVIGATION OR
* COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE SUPPORT MACHINES, OR
* WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE SOFTWARE COULD LEAD DIRECTLY TO
* DEATH, PERSONAL INJURY, OR SEVERE PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH
* RISK ACTIVITIES"). SUN SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED
* WARRANTY OF FITNESS FOR HIGH RISK ACTIVITIES.
*/

import java.applet.*;
import java.awt.*;
import java.net.*;

public class JavaBanner extends Applet implements Runnable
{
   private Graphics offG;
   private Dimension size;
   private Image offImage;
   private Thread animate;

   private Color bgcolor;
   private long delay;
   private String target;

   private ImageList list;

   public void init()
   {
      size = size();

      // Parse the background color.

      String value = getParameter("bgcolor");

      if (value != null)
      {
         bgcolor = new
         Color(Integer.parseInt(value, 16));
      }

      else
      {
         bgcolor = Color.white;
      }

      setBackground(bgcolor);

      offImage = createImage(size.width, size.height);
      offG = offImage.getGraphics();

      // Parse the frame delay.

      value = getParameter("delay");

      if (value != null)
      {
         delay = Integer.parseInt(value);
      }

      else
      {
         delay = 100;
      }

      // Parse the target value;

      value = getParameter("target");

      if (value != null)
      {
         target = new String(value);
      }

      else
      {
         target = "_self";
      }

      list = new ImageList(this);
      list.loadImages();
   }

   public void start()
   {
      if ((animate == null) || (!animate.isAlive()))
      {
         animate = new Thread(this);
      }

      animate.start();
   }

   public void run()
   {
      while (Thread.currentThread() == animate)
      {
         try
         {
            list.update();
            repaint();

            Thread.sleep(delay);
         }

         catch(InterruptedException e)
         {
            e.printStackTrace();
         }
      }
   }

   public void stop()
   {
      if ((animate != null) && (animate.isAlive()))
      {
         animate.stop();
      }
   }

   public void destroy()
   {
      animate = null;
   }

   public void update(Graphics g)
   {
      list.paint(offG);
      paint(g);
   }

   public void paint(Graphics g)
   {
      g.drawImage(offImage, 0, 0, this);
   }

   public boolean mouseDown(Event evt, int x, int y)
   {
      getAppletContext().showDocument(list.getURL(), target);

      if (target.equals("_self"))
      {
         stop();
      }

      return(true);
   }

   public boolean mouseEnter(Event evt, int x, int y)
   {
      list.setMouseEnter(true);
      showStatus(list.getURLString());
      return(true);
   }

   public boolean mouseExit(Event evt, int x, int y)
   {
      list.setMouseEnter(false);
      showStatus("");
      return(true);
   }
}
